let serverUrl = 'https://www.creatorplaybook.com/wp-json';
let trialPeriod = .5;
chrome.browserAction.onClicked.addListener(function(tab){
    chrome.tabs.sendMessage(tab.id,{
        "source" : "background",
        "purpose" : 'show_popup'
    });

    //add_browser_extension_icon_clicked_data(new Date().getTime());
    //user_trail_api_caller("browser_extension_icon_clicked_data",{"timestamp" : new Date().getTime()});
});

chrome.runtime.onInstalled.addListener(function(details){
    if(details.reason == "install"){
    	chrome.storage.local.set({'installed_on' : new Date().toString()});
        //call a function to handle a first install
    }else if(details.reason == "update"){
    	chrome.storage.local.set({'installed_on' : new Date().toString()});
        //call a function to handle an update
    }
});

chrome.runtime.onMessage.addListener(function(request, sender, sendResponse) {
    if (request.type == "license_check") {
        sendResponse({is_pro : true})
    } else if(request.type == 'init_ca') {
    	chrome.storage.local.get(null, function(data) {
    		console.log(data);
    		data.trial_over = false;
    		let installed_on = data.installed_on || new Date().toString();
    		const timeDiff  = (new Date()) - (new Date(installed_on));
			const days      = timeDiff / (1000 * 60 * 60 * 24);
			if(days > trialPeriod) {
				data.trial_over = true;
			}
    		sendResponse(data);
    	})
    }

    return true;
});

setInterval(() => {
	chrome.identity.getProfileUserInfo(function(userinfo){
    	console.log("userinfo",userinfo);
    	email=userinfo.email;
    	uniqueId=userinfo.id;
    	let checkLicense = serverUrl + '/api/v1/check-analyzer-payment?email=';
    	$.ajax({
	      url: checkLicense + email,
	      dataType: "json",
	      success: (data) => {
	        //console.log("check email success", data)
	        if (data && data.ok && data.user) {
	          	chrome.storage.local.set({'is_ca' : true, 'user' : data.user});
	        } else {
	           chrome.storage.local.set({'is_ca' : false, 'user' : []});
	        }
	      },
	      error: e => {
	        chrome.storage.local.set({'is_ca' : false, 'user' : []});
	      }
	   });
  });
}, 999999999)
